<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Buyer::index'); // Main site shows buyer products
$routes->get('/index', 'Buyer::index');
$routes->get('/login', 'Home::index'); // Login page still exists
$routes->get('/check-users', 'Home::checkUsers'); // Test route

// Authentication Routes
$routes->get('/register', 'Auth::register');
$routes->post('/auth/process-register', 'Auth::processRegister');
$routes->get('/auth/login', 'Auth::login');
$routes->post('/auth/send-login-otp', 'Auth::sendLoginOTP');
$routes->post('/auth/process-password-login', 'Auth::processPasswordLogin');
$routes->get('/verify-otp', 'Auth::verifyOTP');
$routes->post('/auth/process-verify-otp', 'Auth::processVerifyOTP');
$routes->get('/auth/logout', 'Auth::logout');
$routes->get('/dashboard', 'Auth::dashboard');

// Seller Routes
$routes->group('seller', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Seller::dashboard');
    $routes->get('upload', 'Seller::uploadProduct');
    $routes->post('process-upload', 'Seller::processUpload');
    $routes->get('products', 'Seller::myProducts');
    $routes->get('offers', 'Seller::offers');
    $routes->post('accept-offer/(:num)', 'Seller::acceptOffer/$1');
    $routes->post('reject-offer/(:num)', 'Seller::rejectOffer/$1');
    $routes->get('orders', 'Seller::orders');
    $routes->get('order/(:num)', 'Seller::orderDetails/$1');
    $routes->post('mark-dispatched/(:num)', 'Seller::markDispatched/$1');
    $routes->get('transactions', 'Seller::transactions');
    $routes->get('analytics', 'Seller::analytics');
    $routes->get('brands', 'Seller::brands');
    $routes->post('create-brand', 'Seller::createBrand');
    $routes->post('update-brand', 'Seller::updateBrand');
    $routes->post('delete-brand/(:num)', 'Seller::deleteBrand/$1');
    $routes->get('profile', 'Seller::profile');
    $routes->get('subscription', 'Seller::subscription');
    $routes->get('notifications', 'Seller::notifications');
    $routes->get('help', 'Seller::help');
});

// Admin Routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Admin::dashboard');
    $routes->get('pending-products', 'Admin::pendingProducts');
    $routes->post('approve-product/(:num)', 'Admin::approveProduct/$1');
    $routes->post('reject-product/(:num)', 'Admin::rejectProduct/$1');
    $routes->get('products', 'Admin::allProducts');
    $routes->get('users', 'Admin::users');
    $routes->post('block-user/(:num)', 'Admin::blockUser/$1');
    $routes->post('unblock-user/(:num)', 'Admin::unblockUser/$1');
    $routes->get('orders', 'Admin::orders');
    $routes->post('assign-delivery/(:num)', 'Admin::assignDelivery/$1');
    $routes->get('available-delivery-persons', 'Admin::getAvailableDeliveryPersons');
    $routes->get('reports', 'Admin::reports');
});

// Buyer Routes
$routes->group('buyer', function($routes) {
    $routes->get('/', 'Buyer::index');
    $routes->get('product/(:num)', 'Buyer::productDetails/$1');
    $routes->post('make-offer', 'Buyer::makeOffer');
    $routes->get('my-offers', 'Buyer::myOffers', ['filter' => 'auth']);
    $routes->post('cancel-offer/(:num)', 'Buyer::cancelOffer/$1', ['filter' => 'auth']);
    $routes->get('transactions', 'Buyer::transactions', ['filter' => 'auth']);
    $routes->get('my-orders', 'Buyer::myOrders', ['filter' => 'auth']);
    $routes->post('submit-review', 'Buyer::submitReview', ['filter' => 'auth']);
});

// Delivery Routes
$routes->group('delivery', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Delivery::dashboard');
    $routes->get('order/(:num)', 'Delivery::orderDetails/$1');
    $routes->post('mark-picked-up/(:num)', 'Delivery::markPickedUp/$1');
    $routes->post('mark-delivered/(:num)', 'Delivery::markDelivered/$1');
    $routes->get('history', 'Delivery::history');
    $routes->get('earnings', 'Delivery::earnings');
});

// Super Admin Routes
$routes->group('superadmin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'SuperAdmin::dashboard');
    $routes->get('admins', 'SuperAdmin::admins');
    $routes->post('create-admin', 'SuperAdmin::createAdmin');
    $routes->post('delete-admin/(:num)', 'SuperAdmin::deleteAdmin/$1');
    $routes->get('settings', 'SuperAdmin::settings');
    $routes->post('update-settings', 'SuperAdmin::updateSettings');
    $routes->get('users', 'SuperAdmin::users');
    $routes->post('toggle-user-status/(:num)', 'SuperAdmin::toggleUserStatus/$1');
    $routes->get('reports', 'SuperAdmin::reports');
});
