<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Browse Products - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        @media (min-width: 1400px) { .container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl { max-width: 1457px !important; } }
        
        /* Header */
        .navbar { padding: 1.2rem 0; box-shadow: 0 2px 10px rgba(0,0,0,0.05); background: white; }
        .navbar-brand { font-weight: 700; font-size: 1.9rem; color: #000 !important; }
        .nav-link { font-weight: 500; color: #000 !important; padding: 0.5rem 1rem; }
        .nav-link:hover { color: #9c27b0 !important; }
        .btn-login { background: #9c27b0; color: white; border-radius: 25px; padding: 0.5rem 1.5rem; font-weight: 600; }
        .btn-login:hover { background: #7b1fa2; color: white; }

        /* Filters */
        .filter-section { background: white; border-radius: 15px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .filter-btn { border: 2px solid #e0e0e0; border-radius: 25px; padding: 8px 20px; background: white; transition: all 0.3s; margin: 5px; }
        .filter-btn:hover, .filter-btn.active { background: #9c27b0; color: white; border-color: #9c27b0; }
        
        /* Product Card */
        .product-card { background: white; border-radius: 15px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); transition: transform 0.3s, box-shadow 0.3s; margin-bottom: 20px; cursor: pointer; }
        .product-card:hover { transform: translateY(-5px); box-shadow: 0 5px 25px rgba(0,0,0,0.15); }
        .product-img { width: 100%; height: 250px; object-fit: cover; }
        .product-badge { position: absolute; top: 10px; right: 10px; padding: 6px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .badge-sale { background: #4caf50; color: white; }
        .badge-rent { background: #2196f3; color: white; }
        .price-tag { font-size: 1.3rem; font-weight: 700; color: #9c27b0; }
        .seller-info { font-size: 13px; color: #666; }
        .rating-badge { background: #ffc107; color: white; padding: 4px 10px; border-radius: 15px; font-size: 12px; font-weight: 600; }
    </style>
</head>
<body>
    <!-- Header -->
    <nav class="navbar navbar-expand-lg navbar-light sticky-top">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url('buyer') ?>">
                <i class="bi bi-shop"></i> Flex Market
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('buyer') ?>">Home</a>
                    </li>
                    <?php if ($user): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= base_url('buyer/my-offers') ?>">My Offers</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= base_url('buyer/transactions') ?>">Orders</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="bi bi-person-circle"></i> <?= esc($user['name']) ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?= base_url('seller/dashboard') ?>"><i class="bi bi-shop"></i> Sell Products</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?= base_url('auth/logout') ?>"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a href="<?= base_url('login') ?>" class="btn btn-login">Login / Sign Up</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container mt-4">
        <!-- Search Bar -->
        <div class="filter-section">
            <form method="get" action="<?= base_url('buyer') ?>">
                <div class="row g-3 align-items-center">
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                            <input type="text" class="form-control" name="search" placeholder="Search products..." value="<?= esc($filters['search'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <select class="form-select" name="sort">
                            <option value="latest">Latest</option>
                            <option value="price_low" <?= ($filters['sort'] ?? '') === 'price_low' ? 'selected' : '' ?>>Price: Low to High</option>
                            <option value="price_high" <?= ($filters['sort'] ?? '') === 'price_high' ? 'selected' : '' ?>>Price: High to Low</option>
                            <option value="popular" <?= ($filters['sort'] ?? '') === 'popular' ? 'selected' : '' ?>>Most Popular</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select class="form-select" name="type">
                            <option value="">All</option>
                            <option value="sell" <?= ($filters['type'] ?? '') === 'sell' ? 'selected' : '' ?>>For Sale</option>
                            <option value="rent" <?= ($filters['type'] ?? '') === 'rent' ? 'selected' : '' ?>>For Rent</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-login w-100">Search</button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Category Filters -->
        <div class="filter-section">
            <h6 class="mb-3">Categories</h6>
            <div class="d-flex flex-wrap">
                <a href="<?= base_url('buyer') ?>" class="filter-btn <?= empty($filters['category']) ? 'active' : '' ?>">All</a>
                <a href="?category=Fashion" class="filter-btn <?= ($filters['category'] ?? '') === 'Fashion' ? 'active' : '' ?>">Fashion</a>
                <a href="?category=Electronics" class="filter-btn <?= ($filters['category'] ?? '') === 'Electronics' ? 'active' : '' ?>">Electronics</a>
                <a href="?category=Home & Living" class="filter-btn <?= ($filters['category'] ?? '') === 'Home & Living' ? 'active' : '' ?>">Home & Living</a>
                <a href="?category=Books" class="filter-btn <?= ($filters['category'] ?? '') === 'Books' ? 'active' : '' ?>">Books</a>
                <a href="?category=Sports" class="filter-btn <?= ($filters['category'] ?? '') === 'Sports' ? 'active' : '' ?>">Sports</a>
            </div>
        </div>

        <!-- Products Grid -->
        <?php if (empty($products)): ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 64px; color: #ccc;"></i>
                <h4 class="mt-3 text-muted">No products found</h4>
                <p class="text-muted">Try adjusting your filters or search terms</p>
            </div>
        <?php else: ?>
            <div class="row">
                <?php foreach ($products as $product): ?>
                    <div class="col-md-6 col-lg-3">
                        <div class="product-card" onclick="window.location.href='<?= base_url('buyer/product/' . $product['id']) ?>'">
                            <div style="position: relative;">
                                <img src="<?= base_url(esc($product['primary_image'] ?? 'placeholder.jpg')) ?>" alt="Product" class="product-img">
                                <span class="product-badge badge-<?= $product['listing_type'] ?>">
                                    <?= $product['listing_type'] === 'sell' ? 'For Sale' : 'For Rent' ?>
                                </span>
                            </div>
                            <div class="p-3">
                                <h6 class="mb-2" style="height: 40px; overflow: hidden;"><?= esc($product['title']) ?></h6>
                                <div class="seller-info mb-2">
                                    <i class="bi bi-shop"></i> <?= esc($product['seller_name']) ?>
                                    <span class="rating-badge ms-2">
                                        <i class="bi bi-star-fill"></i> <?= number_format($product['seller_reliability_score'], 1) ?>
                                    </span>
                                </div>
                                <?php if ($product['brand_name']): ?>
                                    <div class="text-muted small mb-2">
                                        <i class="bi bi-award"></i> <?= esc($product['brand_name']) ?>
                                    </div>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <?php if ($product['listing_type'] === 'sell'): ?>
                                            <div class="price-tag">₹<?= number_format($product['price'], 0) ?></div>
                                            <?php if ($product['original_price'] > $product['price']): ?>
                                                <small class="text-muted" style="text-decoration: line-through;">₹<?= number_format($product['original_price'], 0) ?></small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="price-tag">₹<?= number_format($product['rental_cost'], 0) ?><small>/day</small></div>
                                            <small class="text-muted">Deposit: ₹<?= number_format($product['rental_deposit'], 0) ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <button class="btn btn-sm btn-login" onclick="event.stopPropagation(); window.location.href='/buyer/product/<?= $product['id'] ?>'">
                                        View
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?= $pager->links() ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <footer class="mt-5 py-4 bg-dark text-white">
        <div class="container text-center">
            <p class="mb-0">&copy; 2026 Flex Market. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
