<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Flex Market</title>



    <!-- Bootstrap 5 -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Poppins Font -->

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">



    <style>

        body {

            font-family: 'Poppins', sans-serif;

            background-color: #f8f9fa;

        }



        /* Container max-width */

        @media (min-width: 1400px) {

            .container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl {

                max-width: 1457px !important;

            }

        }



        /* Header */

        .navbar {

            padding: 1.2rem 0;

            box-shadow: 0 2px 10px rgba(0,0,0,0.05);

        }

        .navbar-brand {

            font-weight: 700;

            font-size: 1.9rem;

            color: #000 !important;

        }

        .nav-link {

            font-weight: 500;

            color: #000 !important;

            margin-left: 25px;

            font-size: 1rem;

        }

        .nav-link:hover, .login-link:hover {

            color: #ffc107 !important;

        }

        .login-link {

            color: #000;

            text-decoration: none;

        }



        /* Mega Dropdown */

        .mega-dropdown {

            position: static;

        }

        .mega-dropdown-menu {

            width: 100%;

            border: none;

            border-radius: 0 0 15px 15px;

            box-shadow: 0 10px 30px rgba(0,0,0,0.1);

            padding: 30px 50px;

            background-color: #fff;

            margin-top: 0;

        }

        .mega-title {

            font-weight: 600;

            font-size: 1.1rem;

            color: #000;

            margin-bottom: 15px;

            padding-bottom: 8px;

            border-bottom: 2px solid #ffc107;

            display: inline-block;

        }

        .mega-links a {

            color: #555;

            text-decoration: none;

            font-size: 0.95rem;

            transition: color 0.3s, padding-left 0.3s;

        }

        .mega-links a:hover {

            color: #000;

            padding-left: 5px;

        }



        /* Search Icon */

        .search-icon {

            font-size: 1.3rem;

            color: #000;

        }



        /* Category Cards */

        .category-card {

            height: 380px;

            border-radius: 30px;

            overflow: hidden;

            box-shadow: 0 8px 25px rgba(0,0,0,0.08);

            margin-bottom: 40px;

            display: flex;

        }

        .left-bg, .right-bg {

            background-color: #e8f5e9;

            display: flex;

            align-items: center;

            justify-content: center;

            flex: 0 0 30.666667%;

        }

        .category-title {

            font-weight: 600;

            font-size: 20px;

            color: #000;

        }

        .photo-side {

            background-size: cover;

            background-position: center;

            flex: 1;

        }



        /* Fixed Sidebar */

        .sidebar-wrapper {

            position: sticky;

            top: 100px;

            align-self: flex-start;

        }

        .sidebar-box {

            background-color: #fff;

            border-radius: 20px;

            padding: 30px;

            box-shadow: 0 4px 20px rgba(0,0,0,0.08);

        }

        .btn-sell, .btn-rent {

            padding: 8px 14px;

            border: 1px solid #ddd;

            border-radius: 20px;

            font-size: 14px;

            cursor: pointer;

            transition: all 0.3s ease;

        }

        .btn-sell {

            background-color: #ffc107;

            color: white;

        }

        .btn-sell:hover, .btn-rent:hover {

            background-color: #000;

            color: #fff;

        }

        .btn-start {

            background-color: #ffc107;

            color: #fff;

            border: none;

            border-radius: 30px;

            padding: 15px;

            font-weight: 600;

            width: 100%;

            font-size: 14px;

        }

        .btn-start:hover {

            background-color: #000;

            box-shadow: 0 6px 20px rgba(247, 199, 199, 0.4);

            transform: translateY(-2px);

        }

        .form-control {

            border-radius: 30px;

            padding: 14px 20px;

            border: 1px solid #ddd;

        }



        /* How to Sell Section */

        .section-title {

            font-weight: 700;

            font-size: 2.2rem;

            color: #1a1a1a;

            text-align: center;

            margin: 100px 0 80px;

            letter-spacing: 1px;

        }

        .step-icon {

            font-size: 3rem;

            color: #2c3e50;

            margin-bottom: 20px;

        }

        .step-title {

            font-weight: 600;

            font-size: 1.3rem;

            color: #2c3e50;

            margin-bottom: 15px;

        }

        .step-description {

            font-size: 1rem;

            color: #555;

            line-height: 1.6;

            max-width: 300px;

            margin: 0 auto;

        }



        /* Timeline */

        .timeline {

            position: relative;

            max-width: 70%;

            margin: 60px auto 100px;

            text-align: center;

        }

        .timeline::before {

            content: '';

            position: absolute;

            top: 20px;

            left: 15%;

            right: 15%;

            height: 2px;

            background-color: #e2e8f0;

            z-index: 1;

        }

        .step-number {

            width: 40px;

            height: 40px;

            background-color: #d6b06b;

            color: #fff;

            font-weight: 700;

            font-size: 1.2rem;

            border-radius: 50%;

            display: inline-flex;

            align-items: center;

            justify-content: center;

            margin: 0 100px;

            position: relative;

            z-index: 2;

        }



        /* Footer */

        footer {

            background-color: #3D3B3B;

            color: #b2bec3;

            padding: 66px 0 4px;

            width: 100%;

        }

        .footer-brand {

            font-size: 2rem;

            font-weight: 700;

            color: #fff;

            margin-bottom: 25px;

        }

        .footer-description {

            font-size: 1rem;

            line-height: 1.8;

            max-width: 380px;

            color: #b2bec3;

        }

        .footer-heading {

            font-weight: 600;

            font-size: 1.2rem;

            color: #fff;

            margin-bottom: 30px;

        }

        .footer-links a {

            color: #b2bec3;

            text-decoration: none;

            font-size: 1rem;

            transition: color 0.3s ease;

        }

        .footer-links a:hover {

            color: #fff;

        }

        .social-icons a {

            color: #b2bec3;

            font-size: 1.5rem;

            margin-right: 25px;

            transition: color 0.3s ease;

        }

        .social-icons a:hover {

            color: #fff;

        }

        .copyright {

            text-align: center;

            padding: 20px 0;

            margin-top: 40px;

            border-top: 1px solid #444;

            font-size: 0.95rem;

            color: #636e72;

            background-color: #1e2124;

        }



        /* Responsive */

        @media (max-width: 991px) {

            .sidebar-wrapper { position: static; }

            .category-card { flex-direction: column; height: auto; }

            .left-bg, .right-bg { flex: none; height: 150px; }

            .timeline::before { left: 5%; right: 5%; }

            .step-number { margin: 0 40px; }

        }

    </style>

</head>

<body>



    <!-- Navigation -->

    <nav class="navbar navbar-expand-lg bg-white fixed-top">

        <div class="container">

            <a class="navbar-brand" href="#">Flex Market</a>



            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">

                <span class="navbar-toggler-icon"></span>

            </button>



            <div class="collapse navbar-collapse" id="navbarNav">

                <ul class="navbar-nav me-auto">

                    <li class="nav-item dropdown mega-dropdown">

                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">All Products</a>

                        <div class="dropdown-menu mega-dropdown-menu">

                            <div class="row">

                                <div class="col-lg-4">

                                    <h6 class="mega-title">Clothes</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Casual</a></li>

                                        <li><a href="#">Formal</a></li>

                                        <li><a href="#">Activewear</a></li>

                                    </ul>

                                    <h6 class="mega-title mt-4">Accessories</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Jewelry & Adornments</a></li>

                                        <li><a href="#">Bags & Carryalls</a></li>

                                        <li><a href="#">Headwear & Neckwear</a></li>

                                        <li><a href="#">Body & Footwear</a></li>

                                    </ul>

                                </div>

                                <div class="col-lg-4">

                                    <h6 class="mega-title">Footwear</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Athletic</a></li>

                                        <li><a href="#">Casual</a></li>

                                        <li><a href="#">Formal/Dress</a></li>

                                        <li><a href="#">Boots</a></li>

                                        <li><a href="#">Sandals & Open-Toe</a></li>

                                    </ul>

                                    <h6 class="mega-title mt-4">Electronics</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Consumer Electronics</a></li>

                                        <li><a href="#">Computer Electronics</a></li>

                                        <li><a href="#">Industrial Electronics</a></li>

                                    </ul>

                                </div>

                                <div class="col-lg-4">

                                    <h6 class="mega-title">Furniture</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Seating</a></li>

                                        <li><a href="#">Modern</a></li>

                                        <li><a href="#">Traditional</a></li>

                                        <li><a href="#">Tables</a></li>

                                        <li><a href="#">Bookshelves</a></li>

                                    </ul>

                                    <h6 class="mega-title mt-4">Home appliances</h6>

                                    <ul class="mega-links list-unstyled">

                                        <li><a href="#">Refrigerators</a></li>

                                        <li><a href="#">Washing machines</a></li>

                                        <li><a href="#">Ovens</a></li>

                                        <li><a href="#">ACs</a></li>

                                        <li><a href="#">TVs</a></li>

                                    </ul>

                                </div>

                            </div>

                        </div>

                    </li>

                    <li class="nav-item"><a class="nav-link" href="#">Clothes</a></li>

                    <li class="nav-item"><a class="nav-link" href="#">Accessories</a></li>

                    <li class="nav-item"><a class="nav-link" href="#">Footwear</a></li>

                    <li class="nav-item"><a class="nav-link" href="#">Electronics</a></li>

                    <li class="nav-item"><a class="nav-link" href="#">Furniture</a></li>

                    <li class="nav-item"><a class="nav-link" href="#">Home appliances</a></li>

                </ul>



                <div class="d-flex align-items-center">

                    <a href="#" class="me-4"><i class="bi bi-search search-icon"></i></a>

                    <a href="<?= base_url('register') ?>" class="login-link">LOGIN / REGISTER</a>

                </div>

            </div>

        </div>

    </nav>



    <!-- Main Content -->

    <div class="container my-5 pt-5">

        <div class="row g-5">

            <!-- Category Cards (Scrolling) -->

            <div class="col-lg-8">

                <div class="category-card">

                    <div class="left-bg">

                        <h2 class="category-title">Clothes</h2>

                    </div>

                    <div class="photo-side" style="background-image: url('https://webappproduct.com/project/2149366018.jpg');"></div>

                </div>



                <div class="category-card flex-row-reverse">

                    <div class="right-bg">

                        <h2 class="category-title">Accessories</h2>

                    </div>

                    <div class="photo-side" style="background-image: url('https://webappproduct.com/project/2150229753.jpg');"></div>

                </div>



                <div class="category-card">

                    <div class="left-bg">

                        <h2 class="category-title">Footwear</h2>

                    </div>

                    <div class="photo-side" style="background-image: url('https://webappproduct.com/project/2150991569.jpg');"></div>

                </div>



                <div class="category-card flex-row-reverse">

                    <div class="right-bg">

                        <h2 class="category-title">Electronics</h2>

                    </div>

                    <div class="photo-side" style="background-image: url('https://webappproduct.com/project/2149309649.jpg');"></div>

                </div>

            </div>



            <!-- Fixed Sidebar -->

            <div class="col-lg-4">

                <div class="sidebar-wrapper">

                    <div class="sidebar-box">

                            <h5 class="fw-semibold">Account</h5>
                            <p class="text-muted small mb-4">Register or login from here</p>

                            <!-- Tabs to switch between Register and Login (default Register) -->
                            <ul class="nav nav-pills mb-3" id="authTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="register-tab" data-bs-toggle="pill" data-bs-target="#register" type="button" role="tab">Register</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="login-tab" data-bs-toggle="pill" data-bs-target="#loginTab" type="button" role="tab">Login</button>
                                </li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="register" role="tabpanel">
                                    <?php if (session()->getFlashdata('errors')): ?>
                                        <div class="alert alert-danger small">
                                            <ul class="mb-0">
                                                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                                                    <li><?= esc($error) ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>

                                    <form action="<?= base_url('auth/process-register') ?>" method="POST">
                                        <?= csrf_field() ?>
                                        <div class="mb-2">
                                            <input type="text" name="name" class="form-control mb-2" placeholder="Your Name" required value="<?= old('name') ?>">
                                            <input type="email" name="email" class="form-control mb-2" placeholder="Enter Your Email" required value="<?= old('email') ?>">
                                            <input type="tel" name="mobile" class="form-control mb-2" placeholder="Mobile" required value="<?= old('mobile') ?>">
                                            <input type="password" name="password" class="form-control mb-2" placeholder="Password (min 6)" required>
                                            <textarea name="address" class="form-control mb-2" placeholder="Address" required><?= old('address') ?></textarea>
                                            <input type="text" name="pin_code" class="form-control mb-2" placeholder="PIN Code" required value="<?= old('pin_code') ?>">

                                            <div class="d-flex gap-2 mb-3">
                                                <select name="user_type" class="form-select">
                                                    <option value="buyer" <?= old('user_type') == 'buyer' ? 'selected' : '' ?>>Buyer</option>
                                                    <option value="seller" <?= old('user_type') == 'seller' ? 'selected' : '' ?>>Seller</option>
                                                </select>
                                            </div>

                                            <button class="btn btn-start w-100" type="submit">Register & Send OTP</button>
                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="loginTab" role="tabpanel">
                                    <?php if (session()->getFlashdata('success')): ?>
                                        <div class="alert alert-success small"><?= session()->getFlashdata('success') ?></div>
                                    <?php endif; ?>
                                    <?php if (session()->getFlashdata('error')): ?>
                                        <div class="alert alert-danger small"><?= session()->getFlashdata('error') ?></div>
                                    <?php endif; ?>

                                    <!-- Password Login -->
                                    <form action="<?= base_url('auth/process-password-login') ?>" method="POST" class="mb-3">
                                        <?= csrf_field() ?>
                                        <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
                                        <input type="password" name="password" class="form-control mb-2" placeholder="Password" required>
                                        <button type="submit" class="btn btn-start w-100">Login with Password</button>
                                    </form>

                                    <div class="text-center small my-2 text-muted">OR</div>

                                    <!-- OTP Login -->
                                    <form action="<?= base_url('auth/send-login-otp') ?>" method="POST">
                                        <?= csrf_field() ?>
                                        <input type="email" name="email" class="form-control mb-2" placeholder="Email for OTP" required>
                                        <button type="submit" class="btn btn-outline-secondary w-100">Send OTP</button>
                                    </form>
                                </div>
                            </div>

                        <input type="text" class="form-control mb-3" placeholder="Your Name">

                        <input type="email" class="form-control mb-4" placeholder="Enter Your Email">



                        <button class="btn btn-start">Start now</button>



                        <p class="text-center mt-4 small text-muted">

                            Are you a registered user? <a href="<?= base_url('register') ?>" class="login-link">Login</a>

                        </p>

                    </div>

                </div>

            </div>

        </div>



        <!-- How to Sell Section -->

        <h1 class="section-title">HOW TO SELL</h1>



        <div class="row text-center justify-content-center mb-5">

            <div class="col-lg-4 col-md-6 mb-5">

                <i class="bi bi-clipboard2-data step-icon"></i>

                <h5 class="step-title">Add Product Details</h5>

                <p class="step-description">

                    Start by entering basic information like product name, and specifications to help buyers understand your product better.

                </p>

            </div>

            <div class="col-lg-4 col-md-6 mb-5">

                <i class="bi bi-cloud-arrow-up-fill step-icon"></i>

                <h5 class="step-title">Upload Photos & Videos</h5>

                <p class="step-description">

                    Upload clear images and videos of your product from your mobile or desktop to attract more genuine buyers.

                </p>

            </div>

            <div class="col-lg-4 col-md-6 mb-5">

                <i class="bi bi-tag-fill step-icon"></i>

                <h5 class="step-title">Set Price & Publish</h5>

                <p class="step-description">

                    Add your selling price, stock details, and publish your product to start receiving enquiries instantly.

                </p>

            </div>

        </div>



        <!-- Timeline -->

        <div class="timeline">

            <div class="step-number">1</div>

            <div class="step-number">2</div>

            <div class="step-number">3</div>

        </div>

    </div>



    <!-- Footer -->

    <footer>

        <div class="container">

            <div class="row gx-5 footer-columns">

                <div class="col-lg-4 col-md-6 mb-4">

                    <h2 class="footer-brand">Flex Market</h2>

                    <p class="footer-description">

                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

                    </p>

                </div>

                <div class="col-lg-2 col-md-6 mb-4">

                    <h5 class="footer-heading">Quick Links</h5>

                    <ul class="footer-links list-unstyled">

                        <li><a href="#">Home</a></li>

                        <li><a href="#">About</a></li>

                        <li><a href="#">Sell</a></li>

                        <li><a href="#">Rent</a></li>

                        <li><a href="#">Explore</a></li>

                    </ul>

                </div>

                <div class="col-lg-3 col-md-6 mb-4">

                    <h5 class="footer-heading">Categories</h5>

                    <ul class="footer-links list-unstyled">

                        <li><a href="#">All</a></li>

                        <li><a href="#">Clothes</a></li>

                        <li><a href="#">Accessories</a></li>

                        <li><a href="#">Footwear</a></li>

                        <li><a href="#">Electronics</a></li>

                        <li><a href="#">Furniture</a></li>

                        <li><a href="#">Home appliances</a></li>

                    </ul>

                </div>

                <div class="col-lg-3 col-md-6 mb-4">

                    <h5 class="footer-heading">Our policies</h5>

                    <ul class="footer-links list-unstyled mb-5">

                        <li><a href="#">Return policies</a></li>

                        <li><a href="#">Cancellation policies</a></li>

                        <li><a href="#">Terms of uses</a></li>

                    </ul>

                    <div class="social-icons d-flex">

                        <a href="#"><i class="bi bi-facebook"></i></a>

                        <a href="#"><i class="bi bi-twitter"></i></a>

                        <a href="#"><i class="bi bi-youtube"></i></a>

                        <a href="#"><i class="bi bi-pinterest"></i></a>

                    </div>

                </div>

            </div>

        </div>



        <div class="copyright">

            Copyright © 2025 Flex Market. All rights reserved.

        </div>

    </footer>



    <!-- Bootstrap JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>