<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seller Dashboard - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #9c27b0 0%, #673ab7 100%);
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
            transform: translateX(5px);
        }
        .sidebar .nav-link i { margin-right: 10px; width: 20px; }
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 24px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 25px rgba(0,0,0,0.12);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .gradient-purple { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-blue { background: linear-gradient(135deg, #2193b0 0%, #6dd5ed 100%); }
        .gradient-green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
        .gradient-orange { background: linear-gradient(135deg, #f46b45 0%, #eea849 100%); }
        .gradient-pink { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .offers-table {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
        }
        .badge-pending { background: #ffc107; }
        .badge-accepted { background: #28a745; }
        .badge-rejected { background: #dc3545; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="bi bi-speedometer2"></i> Dashboard</h2>
                        <p class="text-muted mb-0">Welcome back, <?= esc($user['name'] ?? 'Seller') ?>!</p>
                    </div>
                    <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary">
                        <i class="bi bi-cloud-upload"></i> Upload Product
                    </a>
                </div>

                <!-- Stats Cards -->
                <div class="row g-3 mb-4">
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Total Products</p>
                                    <h3 class="mb-0"><?= count($products ?? []) ?></h3>
                                    <small class="text-muted">
                                        <?= ($user['products_uploaded_count'] ?? 0) ?> / <?= getSubscriptionLimits($user['subscription_tier'] ?? 'free')['max_products'] ?> limit
                                    </small>
                                </div>
                                <div class="stat-icon gradient-purple text-white">
                                    <i class="bi bi-box-seam"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Pending Offers</p>
                                    <h3 class="mb-0"><?= count($pending_offers ?? []) ?></h3>
                                    <small class="text-success">Awaiting response</small>
                                </div>
                                <div class="stat-icon gradient-blue text-white">
                                    <i class="bi bi-chat-left-text"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Active Orders</p>
                                    <h3 class="mb-0"><?= count($active_orders ?? []) ?></h3>
                                    <small class="text-info">In progress</small>
                                </div>
                                <div class="stat-icon gradient-green text-white">
                                    <i class="bi bi-receipt"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Seller Rating</p>
                                    <h3 class="mb-0"><?= number_format($user['seller_reliability_score'] ?? 0, 1) ?></h3>
                                    <small class="text-warning">
                                        <i class="bi bi-star-fill"></i> Reliability Score
                                    </small>
                                </div>
                                <div class="stat-icon gradient-orange text-white">
                                    <i class="bi bi-award"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Subscription Alert -->
                <?php 
                    $tier = $user['subscription_tier'] ?? 'free';
                    $uploadCount = $user['products_uploaded_count'] ?? 0;
                    $limits = getSubscriptionLimits($tier);
                    $remaining = $limits['max_products'] - $uploadCount;
                ?>
                <?php if ($remaining <= 1 && $remaining > 0): ?>
                    <div class="alert alert-warning mb-4">
                        <i class="bi bi-exclamation-triangle-fill"></i> 
                        <strong>Almost there!</strong> Only <?= $remaining ?> upload(s) remaining in your <?= ucfirst($tier) ?> plan. 
                        <a href="<?= base_url('seller/subscription') ?>" class="alert-link">Upgrade now</a>
                    </div>
                <?php elseif ($remaining <= 0): ?>
                    <div class="alert alert-danger mb-4">
                        <i class="bi bi-ban"></i> 
                        <strong>Upload Limit Reached!</strong> You've used all uploads in your <?= ucfirst($tier) ?> plan. 
                        <a href="<?= base_url('seller/subscription') ?>" class="alert-link">Upgrade to continue</a>
                    </div>
                <?php endif; ?>

                <!-- Recent Offers -->
                <?php if (!empty($pending_offers)): ?>
                <div class="offers-table mb-4">
                    <div class="p-4 border-bottom">
                        <h5 class="mb-0">
                            <i class="bi bi-chat-left-dots"></i> Recent Offers
                            <span class="badge bg-warning text-dark float-end"><?= count($pending_offers) ?> Pending</span>
                        </h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Product</th>
                                    <th>Buyer</th>
                                    <th>Offered Price</th>
                                    <th>Type</th>
                                    <th>Buyer Rating</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach (array_slice($pending_offers, 0, 5) as $offer): ?>
                                <tr>
                                    <td>
                                        <strong><?= esc($offer['product_title']) ?></strong><br>
                                        <small class="text-muted"><?= esc($offer['category']) ?></small>
                                    </td>
                                    <td><?= esc($offer['buyer_name']) ?></td>
                                    <td>
                                        <?php if ($offer['offer_type'] === 'buy'): ?>
                                            <strong>₹<?= number_format($offer['offered_price'], 2) ?></strong>
                                        <?php else: ?>
                                            <strong>₹<?= number_format($offer['offered_price'], 2) ?>/day</strong><br>
                                            <small class="text-muted">Deposit: ₹<?= number_format($offer['deposit_amount'], 2) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?= $offer['offer_type'] === 'buy' ? 'success' : 'info' ?>">
                                            <?= ucfirst($offer['offer_type']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <i class="bi bi-star-fill text-warning"></i> 
                                        <?= number_format($offer['buyer_reliability_score'] ?? 0, 1) ?>
                                    </td>
                                    <td>
                                        <a href="<?= base_url('seller/offers') ?>" class="btn btn-sm btn-primary">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if (count($pending_offers) > 5): ?>
                    <div class="p-3 text-center border-top">
                        <a href="<?= base_url('seller/offers') ?>" class="text-decoration-none">
                            View All Offers <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="stat-card">
                            <h5 class="mb-3"><i class="bi bi-lightning-charge"></i> Quick Actions</h5>
                            <div class="d-grid gap-2">
                                <a href="<?= base_url('seller/upload') ?>" class="btn btn-outline-primary">
                                    <i class="bi bi-cloud-upload"></i> Upload Product
                                </a>
                                <a href="<?= base_url('seller/products') ?>" class="btn btn-outline-secondary">
                                    <i class="bi bi-box-seam"></i> Manage Products
                                </a>
                                <a href="<?= base_url('seller/offers') ?>" class="btn btn-outline-info">
                                    <i class="bi bi-chat-left-text"></i> View All Offers
                                </a>
                                <?php if (($user['seller_reliability_score'] ?? 0) >= 25): ?>
                                <a href="<?= base_url('seller/brands') ?>" class="btn btn-outline-success">
                                    <i class="bi bi-award"></i> Manage Brands
                                </a>
                                <?php else: ?>
                                <button class="btn btn-outline-secondary" disabled>
                                    <i class="bi bi-lock"></i> Create Brand (Need 25 Score)
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="stat-card">
                            <h5 class="mb-3"><i class="bi bi-graph-up"></i> Performance</h5>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Seller Reliability</span>
                                    <strong><?= number_format($user['seller_reliability_score'] ?? 0, 1) ?>/100</strong>
                                </div>
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar gradient-purple" role="progressbar" 
                                         style="width: <?= ($user['seller_reliability_score'] ?? 0) ?>%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Renter Reliability</span>
                                    <strong><?= number_format($user['renter_reliability_score'] ?? 0, 1) ?>/100</strong>
                                </div>
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar gradient-blue" role="progressbar" 
                                         style="width: <?= ($user['renter_reliability_score'] ?? 0) ?>%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Upload Capacity</span>
                                    <strong><?= $uploadCount ?> / <?= $limits['max_products'] ?></strong>
                                </div>
                                <div class="progress" style="height: 10px;">
                                    <div class="progress-bar gradient-green" role="progressbar" 
                                         style="width: <?= ($uploadCount / $limits['max_products']) * 100 ?>%"></div>
                                </div>
                            </div>
                            <?php if ($tier === 'free'): ?>
                            <a href="<?= base_url('seller/subscription') ?>" class="btn btn-sm btn-warning w-100">
                                <i class="bi bi-gem"></i> Upgrade Plan
                            </a>
                            <?php else: ?>
                            <div class="alert alert-info mb-0">
                                <i class="bi bi-check-circle"></i> <?= ucfirst($tier) ?> Plan Active
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
