<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #1a237e 0%, #0d47a1 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
        .report-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.06);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-shield-check"></i> Super Admin</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('superadmin/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('superadmin/users') ?>" class="nav-link">
                            <i class="bi bi-people"></i> Users
                        </a>
                        <a href="<?= base_url('superadmin/admins') ?>" class="nav-link">
                            <i class="bi bi-person-badge"></i> Admins
                        </a>
                        <a href="<?= base_url('superadmin/settings') ?>" class="nav-link">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                        <a href="<?= base_url('superadmin/reports') ?>" class="nav-link active">
                            <i class="bi bi-file-earmark-text"></i> Reports
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4"><i class="bi bi-file-earmark-text"></i> Reports</h2>

                <!-- Period Selector -->
                <div class="report-card mb-4">
                    <form method="get" class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Report Type</label>
                            <select name="period" class="form-select">
                                <option value="daily" <?= (isset($_GET['period']) && $_GET['period'] === 'daily') ? 'selected' : '' ?>>Daily</option>
                                <option value="weekly" <?= (isset($_GET['period']) && $_GET['period'] === 'weekly') ? 'selected' : '' ?>>Weekly</option>
                                <option value="monthly" <?= (!isset($_GET['period']) || $_GET['period'] === 'monthly') ? 'selected' : '' ?>>Monthly</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-search"></i> Generate Report
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Summary Cards -->
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <div class="report-card">
                            <p class="text-muted mb-1">Total Orders</p>
                            <h3 class="mb-0"><?= $report['total_orders'] ?? 0 ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="report-card">
                            <p class="text-muted mb-1">Total Revenue</p>
                            <h3 class="mb-0">₹<?= number_format($report['total_revenue'] ?? 0) ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="report-card">
                            <p class="text-muted mb-1">New Users</p>
                            <h3 class="mb-0"><?= $report['new_users'] ?? 0 ?></h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="report-card">
                            <p class="text-muted mb-1">New Products</p>
                            <h3 class="mb-0"><?= $report['new_products'] ?? 0 ?></h3>
                        </div>
                    </div>
                </div>

                <!-- Order Details -->
                <div class="report-card">
                    <h5 class="mb-3">Order Details</h5>
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Order ID</th>
                                <th>Product</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Commission</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($orders)): ?>
                                <?php foreach ($orders as $order): ?>
                                    <tr>
                                        <td><?= date('d M Y', strtotime($order['created_at'])) ?></td>
                                        <td>#<?= $order['id'] ?></td>
                                        <td><?= esc($order['product_name'] ?? 'N/A') ?></td>
                                        <td>₹<?= number_format($order['final_price']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $order['status'] === 'delivered' ? 'success' : 'warning' ?>">
                                                <?= ucfirst($order['status']) ?>
                                            </span>
                                        </td>
                                        <td>₹<?= number_format($order['final_price'] * 0.1) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted">No orders found for this period</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
