<?php

// Test script to check dummy users in database
require __DIR__ . '/vendor/autoload.php';

$db = \Config\Database::connect();

$users = $db->table('users')
    ->whereIn('email', ['seller@example.com', 'delivery@example.com', 'admin@example.com', 'superadmin@example.com'])
    ->get()
    ->getResultArray();

echo "=== Dummy Users Check ===\n\n";

foreach ($users as $user) {
    echo "Email: {$user['email']}\n";
    echo "Role: {$user['role']}\n";
    echo "User Type: {$user['user_type']}\n";
    echo "Has Password: " . (!empty($user['password']) ? 'Yes' : 'No') . "\n";
    
    // Test passwords
    $testPasswords = [
        'seller@example.com' => 'sellerpass',
        'delivery@example.com' => 'deliverypass',
        'admin@example.com' => 'adminpass',
        'superadmin@example.com' => 'superpass',
    ];
    
    $expectedPass = $testPasswords[$user['email']] ?? '';
    if ($expectedPass) {
        $verified = password_verify($expectedPass, $user['password']);
        echo "Password Verified: " . ($verified ? 'YES ✓' : 'NO ✗') . "\n";
    }
    
    echo "\n";
}

// Check delivery_persons table
echo "=== Delivery Person Entry ===\n\n";
$deliveryPerson = $db->table('delivery_persons')
    ->join('users', 'users.id = delivery_persons.user_id')
    ->where('users.email', 'delivery@example.com')
    ->get()
    ->getRowArray();

if ($deliveryPerson) {
    echo "Found delivery person entry:\n";
    echo "User ID: {$deliveryPerson['user_id']}\n";
    echo "Vehicle: {$deliveryPerson['vehicle_type']}\n";
    echo "Available: " . ($deliveryPerson['is_available'] ? 'Yes' : 'No') . "\n";
} else {
    echo "No delivery person entry found!\n";
}
